define([
    'backbone',
    'marionette',
    'App',
    'modules/notifications/notifications-module',
    'modules/notifications/notifications-layout-view',
    'modules/notifications/notification-details-view',
    'modules/notifications/notifications-radio',
],
function(Backbone, Marionette, app, module, NotificationsView, NotificationDetailsView, radio) {
    'use strict';

    var router = {
        routes: {'notifications': 'showList'},
        controller: {
            showList: function() {
                $.when(module.fetchCollection()).then(function() {
                    app.show(new NotificationsView());
                });
            },
            showDetails: function(model) {
                app.show(new NotificationDetailsView({model: model}));
            },
        },
    };

    radio.on('notifications:show-details', function(model) {
        router.controller.showDetails(model);

        Backbone.history.navigate('notification-details');
    });

    return router;
});
